# -*- coding: utf-8 -*-

#JOINT_FORCES.PY
#@author: Thomas Gillis
#
#Created on 1/7/2013
#Last update on 3/7/2013
#
#Copyright 2013 Universite Catholique de Louvain


import numpy as np

def user_LinkForces(Z,Zd,mbs,tsim,identity):
    """ Compute the link force for a given link id
    
    :param Z: the position between the two anchor points
    :param Zd: the velocity between the two ancho points
    :param mbs: the mbs Data structure
    :param tsim: the simulation time
    :param identity: the identity of the link
    
    """
    
    Flink=0
    #==========================================================================
    # BEGIN OF USER CODE
    #==========================================================================
    L1 = mbs.link_id["MyLink"]
    if identity == L1:
        K  = mbs.user_model['mylink']['K']
        C  = mbs.user_model['mylink']['C']
        L0 = mbs.user_model['mylink']['L0']
        Flink = K*(Z-L0)+C*Zd
    
    #==========================================================================
    # END OF USER CODE
    #==========================================================================
    return Flink
    
